import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/admin/lab',
    component: AppLayout,
    redirect: '/admin/lab/experiment',
    children: [
      { path: 'experiment', component: () => import('./views/Index.vue') },
      { path: 'experiment/:id', component: () => import('./views/View.vue'), props: true },
      { path: 'experiment/group/:id', component: () => import('./views/Group.vue'), props: true },
      { path: 'experiment/report/:id', component: () => import('./views/Report.vue'), props: true },
      { path: 'experiment/ed/rule/:id', component: () => import('./views/EventDataRule.vue'), props: true },
      { path: 'experiment/ed/generate/:id', component: () => import('./views/EventDataGenerate.vue'), props: true },
      { path: 'experiment/ed/view/:id', component: () => import('./views/EventDataView.vue'), props: true }
    ]
  }
]
