import httpRequest from '@/utils/axios'
import type { ContestCreateParams, ContestUpdateParams } from './types'

// 获取赛项列表
export function getContestItemList(params?: { page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition/list', { params })
}

// 获取赛项详情
export function getContestItem(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/detail', { params })
}

// 创建赛项
export function createContest(data: ContestCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition/create', data)
}

// 更新赛项
export function updateContest(data: ContestUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition/update', data)
}

// 更新评分规则
export function updateContestRules(data: ContestUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-rule/save', data)
}
// 获取赛项课程列表
export function getContestCourseList(params: { organ_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/courses', { params })
}
// 获取赛项指导老师列表
export function getContestTeacherList(params: { organ_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/teachers', { params })
}
// 获取赛项关联班级列表
export function getContestClassList(params: { experiment_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition/class-add', { params })
}
// 赛项关联班级
export function experimentAddClass(data: { experiment_id: string; classes_id: string; type: 'add' | 'delete' }) {
  return httpRequest.post('/api/resource/v1/backend/competition/class-add', data)
}

// 获取班级学生列表
export function getClassStudentList(params: { class_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition/class-students', { params })
}

// 获取班级小组列表
export function getContestClassGroupsList(params: { experiment_id: string; class_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/class-teams', { params })
}

// 获取赛项小组
export function getContestGroup(params: { team_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition/team-view', { params })
}

// 新增赛项小组
export function experimentAddClassGroup(data: { experiment_id: string; class_id: string; name: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition/team-add', data)
}

// 赛项小组添加学生
export function experimentGroupAddStudent(data: { team_id: string; students_id: string; type: 'add' | 'delete' }) {
  return httpRequest.post('/api/resource/v1/backend/competition/team-add-student', data)
}

// 获取赛项关联班级列表
export function getContestGroupStudentList(params: { team_id: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition/team-add-student', { params })
}

// 获取指导老师列表
export function getTeacherList(params?: { name?: string }) {
  return httpRequest.get('/api/resource/v1/backend/teacher/faculty-advisers', { params })
}
