import type { SystemDictionary } from '@/types'

export interface ContestItemTeacher {
  id: string
  name: string
}

export interface ContestItem {
  id: string
  name: string
  type: string
  start_range: string
  end_range: string
  start_at: string
  end_at: string
  apply_expiration_date: string
  status: string
  logo: string
  cover: string
  train_platform_uri: string
  competition_uri: string
  publish_status: string
  created_operator: string
  updated_operator: string
  created_time: string
  updated_time: string
  teachers: ContestItemTeacher[]
  host_unit: SystemDictionary
  technical_support_unit: SystemDictionary
  organizers: SystemDictionary[]
  apply_count: number
  expert_count: number
}

export interface ContestCreateParams {
  name: string
  host_unit_id: string
  organizer_ids: string
  technical_support_unit_id: string
  type: string
  start_range: number
  end_range: number
  start_at: number
  end_at: number
  apply_expiration_date: number
  status: string
  logo: string
  cover: string
  train_platform_uri: string
  competition_uri: string
  teacher_ids: string[]
}

export type ContestUpdateParams = ContestCreateParams & { id: string }
