import httpRequest from '@/utils/axios'
import type { ContestCreateParams, ContestUpdateParams, ContestBookUpdateParams, ContestVideoCreateParams, ContestVideoUpdateParams } from './types'

// 获取赛项列表
export function getContestList(params?: { page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition/list', { params })
}

// 获取赛项详情
export function getContest(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/detail', { params })
}

// 创建赛项
export function createContest(data: ContestCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition/create', data)
}

// 更新赛项
export function updateContest(data: ContestUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition/update', data)
}

// 获取指导老师列表
export function getTeacherList(params?: { name?: string; email?: string; sso_id?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/teacher/faculty-advisers', { params })
}

// 获取评分规则详情
export function getContestRules(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-rule/detail', { params })
}
// 更新评分规则
export function updateContestRules(data: ContestUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-rule/save', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}
// 获取考试列表
export function getExamList(params: { project: string; q?: string; name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/exam/search-all-exam', { params })
}

// 获取评分细则详情
export function getContestRuleBook(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-rubric/detail', { params })
}
// 创建评分细则
export function createContestRuleBook(data: ContestBookUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-rubric/create', data)
}
// 更新评分细则
export function updateContestRuleBook(data: ContestBookUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-rubric/update', data)
}

// 获取赛项指导书详情
export function getContestBook(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-book/detail', { params })
}

// 获取赛项指导书详情
export function getContestBooks(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-book/list', { params })
}

// 添加赛项指导书
export function createContestBook(data: ContestBookUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-book/create', data)
}
// 更新赛项指导书
export function updateContestBook(data: ContestBookUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-book/update', data)
}
// 删除赛项指导书
export function deleteContestBook(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-book/delete', data)
}

// 获取赛项操作视频列表
export function getContestVideoList(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-video/list', { params })
}
// 获取赛项操作视频详情
export function getContestVideo(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-video/detail', { params })
}
// 获取赛项操作视频详情
export function getContestVideoPalyInfo(params: { source_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-video/replay-list', { params })
}
// 添加赛项操作视频
export function createContestVideo(data: ContestVideoCreateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-video/create', data)
}
// 更新赛项操作视频
export function updateContestVideo(data: ContestVideoUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-video/update', data)
}
// 删除赛项操作视频
export function deleteContestVideo(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-video/delete', data)
}

// 获取赛项评分专家列表
export function getContestExpertList(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/experts', { params })
}
// 获取赛项未绑定的评分专家列表
export function getContestUnbindExpertList(params: { competition_id: string; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/expert/unbind-competition-list', { params })
}
// 更新赛项评分专家
export function updateContestExpert(data: { id: string; experts: Record<string, any>[] }) {
  return httpRequest.post('/api/resource/v1/backend/competition/bind-experts', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

// 获取评分专家详情
export function getExpert(params: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/expert/detail', { params })
}
// 获取赛项选手列表
export function getContestantList(params?: { student_name?: string; page?: number; 'per-page'?: number }) {
  return httpRequest.get('/api/resource/v1/backend/competition-competitor/list', { params })
}

// 获取平台标识列表
export function getPlatformKeys(params?: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-book/platform-keys', { params })
}

// 获取赛项试题
export function getQuestionList(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-question/list', { params })
}
// 添加大赛试题
export function createQuestion(data: ContestBookUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-question/create', data)
}
// 更新大赛试题
export function updateQuestion(data: ContestBookUpdateParams) {
  return httpRequest.post('/api/resource/v1/backend/competition-question/update', data)
}
// 删除大赛试题
export function deleteQuestion(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-question/delete', data)
}

// 获取赛项模块试卷
export function getAllExamList(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-exam/list', { params })
}
// 添加大赛试卷
export function createExam(data: { competition_id: string; exam_id: string; sort: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-exam/create', data)
}
// 更新大赛试卷
export function updateExam(data: { id: string; exam_id: string; sort: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-exam/update', data)
}
// 删除大赛试卷
export function deleteExam(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-exam/delete', data)
}

// 获取赛项抽签列表
export function getDrawLotList(params: { competition_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/draw-rules', { params })
}
// 添加赛项抽签
export function createDrawLot(data: { competition_id: string; type: string; total: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-draw/create-draw-rule', data)
}
// 更新赛项抽签
export function updateDrawLot(data: { id: string; total: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-draw/update-draw-rule', data)
}
// 删除赛项抽签
export function deleteDrawLot(data: { id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition-draw/delete-draw-rule', data)
}
// 获取赛项抽签选手列表
export function getDrawLotStudentList(params: { draw_rule_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/student-draw-list', { params })
}
// 导出赛项抽签选手列表
export function exportDrawLotStudentList(params: { draw_rule_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/export-student-draw-list', { params })
}
// 获取学员的抽签详情
export function getStudentDrawLotInfo(params: { draw_rule_id: string; student_id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition-draw/student-draw-info', { params })
}

// 获取学员的抽签详情
export function getExperimentsList(params: {
  type: number; name?: string; 'per-page': number
}) {
  return httpRequest.get('/api/resource/v1/backend/competition/experiments', { params })
}

// 赛项绑定实验
export function bindExperiment(data: { id: string; experiment_id: any }) {
  return httpRequest.post('/api/resource/v1/backend/competition/bind-experiment', data)
}

// 删除绑定的实验
export function unbindExperiment(data: { id: string, experiment_id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition/unbind-experiment', data)
}

// 获取赛项列表
export function getClassList(params?: { id: string }) {
  return httpRequest.get('/api/resource/v1/backend/competition/classes', { params })
}

// 评分专家绑定班级
export function bindClass(data: { id: string; expert_id: string; class_id: string }) {
  return httpRequest.post('/api/resource/v1/backend/competition/expert-bind-class', data)
}
