import httpRequest from '@/utils/axios'
import type { CaseCreateItem } from './types'

// 获取实验列表
export function getExperimentList(params: { course_id?: string }) {
  return httpRequest.get('/api/lab/v1/teacher/cases/experiments', { params })
}

// 获取案例列表
export function getCaseList(params?: {
  name?: string
  type?: string
  experiment_name?: string
  page?: number
  page_size?: number
}) {
  return httpRequest.get('/api/lab/v1/teacher/cases/list', { params })
}

// 获取案例详情
export function getCase(params: { id: string }) {
  return httpRequest.get('/api/lab/v1/teacher/cases/view', { params })
}

// 创建案例
export function createCase(data: CaseCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/cases/create', data)
}

// 更新案例
export function updateCase(data: CaseCreateItem) {
  return httpRequest.post('/api/lab/v1/teacher/cases/update', data)
}

// 删除案例
export function deleteCase(params: { id: string }) {
  return httpRequest.post('/api/lab/v1/teacher/cases/delete', params)
}

// 关联实验、删除实验
export function bindExperiment(params: { case_id: string; experiment_id: string; type: 'add' | 'delete' }) {
  return httpRequest.post('/api/lab/v1/teacher/cases/experiments', params)
}
