import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/admin/lab',
    redirect: '/admin/lab/example',
  },
  {
    path: '/admin/lab/example',
    component: AppLayout,
    children: [
      { path: '', component: () => import('./views/Index.vue') },
      { path: 'create', component: () => import('./views/Create.vue') },
      { path: ':id/edit', component: () => import('./views/Update.vue'), props: true },
      { path: ':id', component: () => import('./views/View.vue'), props: true },
    ],
  },
]
