import httpRequest from '@/utils/axios'

// 获取课程列表
export function getCourseList(params?: { id?: string; semester_ids?: string; elective_types?: string }) {
  return httpRequest.get('/api/learn/api/v1/course/list', { params })
}
// 搜索课程
export function searchCourseList(params?: { search_name?: string; semester_ids?: string; elective_types?: string }) {
  return httpRequest.get('/api/learn/api/v1/course/search', { params })
}
// 获取学期
export function getSemesterList() {
  return httpRequest.get('/api/learn/api/v1/semester/student-semesters')
}
// 置顶课程
export function topCourse(data: { id: string; status: number }) {
  return httpRequest.post('/api/learn/api/v1/course/sticky-top', data)
}

// 获取课程详情信息
export function getCourse(params: { course_id: string; semester_id: string }) {
  return httpRequest.get(`/api/learn/api/v1/course/${params.course_id}/detail/${params.semester_id}`, { params })
}

// 获取章节列表
export function getChapterTreeList(data: { course_id: string; semester_id: string }) {
  return httpRequest.post('/api/learn/api/v1/chapter/tree', data)
}

// 课程考核列表
export function getChapterVideoTreeList(data: { course_id: string; semester_id: string }) {
  return httpRequest.post('/api/learn/api/v1/chapter/video-tree', data)
}

// 收藏/取消收藏
export function collectionResource(data: {
  course_id: string
  semester_id: string
  chapter_id: string
  section_id: string
  source_id: string
  type: number
  status: number
}) {
  return httpRequest.post('/api/learn/api/v1/collection/resource', data)
}

// 获取课程大作业详情
export function getCourseWork(data: { course_id: string; semester_id: string }) {
  return httpRequest.post('/api/learn/api/v1/job/detail', data)
}
// 提交大作业
export function submitCourseWork(data: {
  course_id: string
  semester_id: string
  title: string
  content: string
  attachments?: string
}) {
  return httpRequest.post('/api/learn/api/v1/job/submit', data)
}

// 获取课程考试列表
export function getCourseExamList(params: { course_id: string; semester_id: string }) {
  return httpRequest.get('/api/learn/api/v1/question-bank/papers', { params })
}

// 获取课程直播列表
export function getCourseLiveList(data: { course_id: string; semester_id: string }) {
  return httpRequest.post('/api/learn/api/v1/meeting/list', data)
}

// 获取课程资料列表
export function getCourseMaterialList(params: { course_id: string; semester_id: string }) {
  return httpRequest.get(`/api/learn/api/v1/course/${params.course_id}/${params.semester_id}/informations`, { params })
}

// 获取课程小节信息
export function getCourseSection(data: { section_id: string; semester_id: string }) {
  return httpRequest.post('/api/learn/api/v1/chapter/section/detail', data)
}

// 获取课程视频信息
export function getCoursePlayInfo(params: { source_id: string }) {
  return httpRequest.get(`/api/learn/api/v1/video/vod/${params.source_id}/playing-info`, { params })
}
// 获取视频观看记录
export function getVideoRecords(data: {
  chapter_id: string
  course_id: string
  section_id: string
  semester_id: string
  video_id: string
}) {
  return httpRequest.post('/api/learn/api/v1/course/video/recent-viewings', data)
}
// 上传视频观看记录
export function uploadVideoRecords(data: {
  chapter_id: string
  course_id: string
  cumulative_playing_time: string
  current_playing_time: number
  max_playing_time: number
  section_id: string
  semester_id: string
  valid_playing_time: number
  video_id: string
}) {
  return httpRequest.post('/api/learn/api/v1/course/video/upload-records', data)
}

/**
 *
 * 考试、测验start
 */

// 获取试卷详情
export function getPaper(data: { course_id: string; semester_id: string; paper_id: string; type: number }) {
  return httpRequest.post('/api/learn/api/v1/question-bank/paper-question/detail', data)
}
// 缓存试卷
export function cachePaper(data: {
  course_id: string
  semester_id: string
  paper_id: string
  type: number
  question: any
}) {
  return httpRequest.post('/api/learn/api/v1/question-bank/paper-question/cache', data)
}
// 提交试卷
export function submitPaper(data: {
  course_id: string
  semester_id: string
  paper_id: string
  type: number
  question: any
}) {
  return httpRequest.post('/api/learn/api/v1/question-bank/paper/hand', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

/**
 *
 * 考试、测验end
 */
