import type { CourseType, ChapterType, ResourceType } from '@/types'

export interface CourseListParamsType {
  [key: string]: any
  elective_types: string[]
  id: string
  semester_ids: string[]
}
export interface CourseListItemType extends CourseType {
  schedule: string
  section?: ChapterType
  semester_id: string
  watch_video_length: number
}

export interface CourseAssessChapterType extends CourseChapterType {
  schedule: number
  video_count: number
  video_length: number
  watch_video_length: number
}

// 课程章类型
export interface CourseChapterType {
  id: string
  name: string
  resource_id: string
  resource_type: number
  sections: CourseSectionType[]
  depth: number
}

// 课程节类型
export interface CourseSectionType {
  id: string
  name: string
  resource_id: string
  resource_type: number
  resources: CourseResourceType[]
  depth: number
}

// 课程资源类型
export interface CourseResourceType {
  id: string
  name: string
  resource_id: string
  resource_type: number
  collection_count: number
  info: ResourceType
  depth: number
  is_finished?: number
  paper_status?: number
  can_download: number
}

export interface VideoRecordType {
  cumulative_playing_time: string
  current_playing_time: number
  max_playing_time: number
  valid_playing_time: number
  watchedTimePoint: number[]
}

export interface PlayItemType {
  BitDepth: number
  Bitrate: string
  CreationTime: string
  Definition: string
  Duration: string
  Encrypt: 0
  Format: string
  Fps: string
  HDRType: string
  Height: number
  JobId: string
  ModificationTime: string
  NarrowBandType: string
  PlayURL: string
  PreprocessStatus: string
  Size: number
  Specification: string
  Status: string
  StreamType: string
  Width: number
  DefinitionName: string
}
