import type { CourseType, ChapterType, ResourceType } from '@/types'

type CollectionInfo = ResourceType & {
  id: string
  sso_id: string
  sso_type: number
  title: string
  semester_id: string
  class_id: string
  course_id: string
  chapter_id: string
  type: number
  is_top: number
  top_time: null
  is_hot: number
  pv: number
  uv: number
  reply_count: number
  created_time: string
  updated_time: string
  delete_time: number
}
export interface CollectionType {
  chapter_id: string
  course_id: string
  id: string
  info: CollectionInfo
  section_id: string
  semester_id: string
  semester: CollectionSemesterType
  source_id: string
  status: number
  type: number
  resource_type: number
  can_download: number
  course: Pick<CourseType, 'id' | 'name' | 'course_alias_name' | 'course_id'>
  chapter: Pick<ChapterType, 'id' | 'name'>
}

export interface CollectionSemesterType {
  id: string
  name: string
}

export type AllCourseType = Pick<CourseType, 'id' | 'name' | 'course_alias_name' | 'course_id' | 'cover' | 'semester'>
