import fs from 'fs'
import path from 'path'
import { fileURLToPath, URL } from 'url'

import { defineConfig } from 'vite'
import vue from '@vitejs/plugin-vue'
import AutoImport from 'unplugin-auto-import/vite'

// https://vitejs.dev/config/
export default defineConfig(({ mode }) => ({
  base: mode === 'prod' ? 'https://webapp-pub.ezijing.com/website/prod/saas-learn/' : '/',
  plugins: [
    vue({ reactivityTransform: true }),
    AutoImport({
      imports: ['vue', 'vue/macros', 'vue-router'],
      dts: true,
      eslintrc: { enabled: true }
    })
  ],
  resolve: {
    alias: {
      '@': fileURLToPath(new URL('./src', import.meta.url))
    }
  },
  server: {
    open: true,
    host: 'dev.ezijing.com',
    https: {
      key: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.key')),
      cert: fs.readFileSync(path.join(__dirname, './https/dev.ezijing.com.pem'))
    },
    proxy: {
      '/api': 'https://saas-learn.ezijing.com'
    }
  }
}))
