import { getCourseList, getCourseChapterList } from '@/api/base'

interface Semester {
  id: string
  name: string
}

interface Course {
  id: string
  course_id: string
  name: string
  cover: string
  course_alias_name: string
  semester: Semester
}

interface Chapter {
  id: string
  name: string
}
const courses = ref<Course[]>([])

export function useGetCourseList() {
  const courseValue = ref('')
  const chapters = ref<Chapter[]>([])
  // 获取课程列表
  function getCourses() {
    if (courses.value.length) return
    getCourseList().then(res => {
      courses.value = res.data.items
    })
  }
  // 获取章节列表
  function getChapters() {
    if (!courseValue.value) {
      chapters.value = []
      return
    }
    getCourseChapterList({ course_id: courseValue.value }).then(res => {
      chapters.value = res.data.items
    })
  }

  getCourses()

  watch(courseValue, () => {
    getChapters()
  })

  return { courses, courseValue, chapters }
}
