import httpRequest from '@/utils/axios'

// 获取帖子列表
export function getPostList(params: {
  search_by: number
  order_by: number
  course_id?: string
  semester_id?: string
  chapter_id?: string
  type?: string
  page?: number
  limit?: number
}) {
  return httpRequest.get('/api/learn/api/v1/discussions', { params })
}

// 获取置顶帖子列表
export function getTopPostList(params?: { course_id?: string; semester_id?: string }) {
  return httpRequest.get('/api/learn/api/v1/discussion/top-list', { params })
}

// 获取帖子详情
export function getPostAndDiscussList(params: { id: string }) {
  return httpRequest.get(`/api/learn/api/v1/discussion/${params.id}/detail-list`, { params })
}

// 获取回复列表
export function getCommitList(params: { floor_id: string; page?: number; limit?: number }) {
  return httpRequest.get(`/api/learn/api/v1/discussion/reply-list/${params.floor_id}`, { params })
}

// 创建帖子
export function createPost(data: {
  course_id: string
  semester_id: string
  chapter_id: string
  type: string
  title: string
  content: string
  files: string
}) {
  return httpRequest.post('/api/learn/api/v1/discussion/post', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

// 回复帖子
export function replyToPost(data: {
  id: string
  reply_type: number
  content: string
  files?: string
  floor_id?: string
  reply_id?: string
}) {
  return httpRequest.post(`/api/learn/api/v1/discussion/${data.id}/reply`, data, {
    headers: { 'Content-Type': 'application/json' }
  })
}
