import httpRequest from '@/utils/axios'

// 获取收藏列表
export function getCollectionList(data?: {
  type?: string
  course_id?: string
  semester_id?: string
  types?: string[]
}) {
  return httpRequest.post('/api/learn/api/v1/collection/list', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

// 收藏/取消收藏
export function collectionResource(data: {
  course_id: string
  semester_id: string
  chapter_id: string
  section_id: string
  source_id: string
  type: number
  status: number
}) {
  return httpRequest.post('/api/learn/api/v1/collection/resource', data)
}

// 获取所有课程
export function getCourseList() {
  return httpRequest.get('/api/learn/api/v1/course/all')
}
