import httpRequest from '@/utils/axios'
// 修改用户资料
export function updateUser(data: { real_name: string; avatar: string; gender: number }) {
  return httpRequest.post('/api/usercenter/v2/frontend/user/update-user', data)
}
// 通过cookie修改密码
export function updatePassword(data: { old_password: string; password: string; password_r: string }) {
  return httpRequest.post('/api/usercenter/v2/frontend/user/change-pwd-by-cookie', data)
}

// 获取投诉建议列表
export function getSuggestionList(params?: { page?: number; limit?: number; status?: string }) {
  return httpRequest.get('/api/learn/api/v1/suggestion/list', { params })
}
// 提交投诉建议
export function submitSuggestion(data: { title: string; content: string; files?: string }) {
  return httpRequest.post('/api/learn/api/v1/suggestion/complaint', data)
}
