import type { Component } from 'vue'
import type { questionType, liveStatus } from '@/utils/dictionary'

export interface IMenuItem {
  tag?: string
  name: string
  path: string
  icon?: Component
  children?: IMenuItem[]
  iconImg?: string
  iconActiveImg?: string
}

// 用户类型
export interface UserType {
  avatar: string
  email: string
  id: string
  mobile: string
  name: string
  realname: string
  nickname: string
  username: string
  gender: number
}

// 课程类型
export interface CourseType {
  course_id: string
  cover: string
  credit: number
  elective_type: number
  id: string
  is_finished: number
  is_top: number
  lecturers?: LecturerType[]
  name: string
  course_alias_name: string
  online_type: number
  previous_preparation: string
  represent: string
  semester: SemesterType
  target: string
}

// 章节类型
export interface ChapterType {
  chapter_id?: string
  section_id?: string
  resource_id?: string
  id: string
  name: string
  schedule: string
  watch_video_length: number
  is_finished: number
}

// 学期类型
export interface SemesterType {
  id: string
  name: string
  start_time?: string
  end_time?: string
}

// 讲师类型
export interface LecturerType {
  avatar: string
  id: string
  name: string
  summarize: string
}

// 资源类型
export type ResourceType = FileType & LiveType & PaperType

// 资源类型
export interface FileType {
  id: string
  knowledge_points: string
  name: string
  type: string
  pdf?: string
  url?: string
  cover?: string
  length?: number
  size: number
  source_id: string
  ppt_arr?: PptType[]
  can_download: number
  video_type?: 1 | 2
  video_play_address?: string
}

export interface PptType {
  id: string
  name: string
  point: number
  url: string
  video_id: string
}

// 直播类型
export interface LiveType {
  end_time: number
  format_status: number
  id: string
  join_url: string
  meeting_code: string
  meeting_id: string
  meeting_type: number
  start_time: number
  status: LiveStatusType
  sub_meetings: []
  subject: string
}
export type LiveStatusType = keyof typeof liveStatus

// 试卷类型
export interface PaperType {
  id: string
  is_multiple_exams: 0 | 1
  minimum_paper_handing_time: 0 | 1
  multiple_test_score_rule: 0 | 1
  paper_category: PaperCategoryType
  paper_labels: string
  paper_question_order: 0 | 1
  paper_times: number
  paper_title: string
  paper_total_score: number
  paper_type: number
  paper_uses: number
  pass_score: number
  permission: number
  project_prefix: string
  paper_status: number
}

// 试卷分类类型
export interface PaperCategoryType {
  id: string
  category_name: string
  name: string
}

export type QuestionType = keyof typeof questionType

export interface PaperQuestionType {
  id: string
  project_prefix: string
  permission: number
  question_type: QuestionType
  question_title: string
  question_content: string
  common_content: string
  question_options: PaperQuestionOptionType[]
  question_analysis: string
  question_difficulty: number
  status: number
  group_id: string
  question_order: number
  question_tag: string
  is_parent: number
  child_question_type: number
  score: number
  children?: PaperQuestionType[]
  reviews?: string
  user_answer: string
  user_answer_status?: boolean
  user_score?: number
  is_reviewed?: boolean
}
export interface PaperQuestionOptionType {
  checked_option: string
  option: string
  id: string
  user_checked: boolean
}
