import dayjs from 'dayjs'
import { liveStatus, questionType } from './dictionary'
import type { LiveStatusType, QuestionType } from '@/types'

// 直播时间
export function formatLiveDate(startTime: number) {
  return dayjs(startTime * 1000).format('YYYY-MM-DD HH:mm')
}

// 直播状态
export function formatLiveStatus(status: LiveStatusType) {
  return liveStatus[status] || status
}

// 试题类型
export function formatQuestionType(type: QuestionType) {
  return questionType[type] || type
}

// 是否是视频
export function isVideo(url: string) {
  return url?.includes('.mp4')
}

export function content2Html(content: string) {
  return content?.replaceAll('\n', '<br>')
}
