export interface Post {
  id: string
  sso_id: string
  sso_type: number
  title: string
  semester_id: string
  class_id: string
  course_id: string
  chapter_id: string
  type: number
  is_top: number
  top_time: string
  is_hot: number
  pv: number
  uv: number
  reply_count: number
  created_time: string
  updated_time: string
  delete_time: string
  collection_count: 0 | 1
  last_post_time: string
}

export interface PostItem extends Post {
  reply: {
    id: string
    discussion_id: string
    content: string
    created_time: string
    updated_time: string
    files: File[]
  }
  sso_user: User
}

export type TopPostItem = Pick<Post, 'id' | 'title' | 'type' | 'created_time' | 'updated_time' | 'top_time'> & {
  course: Course
}

export interface DiscussItem {
  id: string
  discussion_id: string
  sso_id: string
  sso_type: 2
  content: string
  files: File[]
  is_first: number
  reply_type: number
  floor_id: string
  reply_id: string
  reply_sso_id: string
  reply_sso_type: number
  created_time: string
  updated_time: string
  delete_time: string
  sso_user: User
  child_replies: DiscussCommentItem[]
}

export interface DiscussCommentItem {
  id: string
  discussion_id: string
  sso_id: string
  sso_type: number
  content: string
  files: File[]
  is_first: number
  reply_type: number
  floor_id: string
  reply_id: string
  reply_sso_id: string
  reply_sso_type: number
  created_time: string
  updated_time: string
  delete_time: string
  sso_user: User
  reply_sso_user: User
}

export interface User {
  id: string
  username: string
  nickname: string
  realname: string
  avatar: string
  discussion_level: number
}

export interface File {
  name: string
  url: string
  type: string
  size: string
  upload_time: string
}

export interface Course {
  id: string
  name: string
  cover: string
}
