import type { RouteRecordRaw } from 'vue-router'
import AppLayout from '@/components/layout/Index.vue'

export const routes: Array<RouteRecordRaw> = [
  {
    path: '/course',
    component: AppLayout,
    children: [
      {
        path: '',
        component: () => import('./views/CourseIndex.vue'),
        children: [{ path: 'view', component: () => import('./views/CourseView.vue'), props: true }]
      },
      { path: 'player', component: () => import('./views/CoursePlayer.vue'), props: true },
      { path: 'exam', component: () => import('./views/CourseExam.vue'), props: true },
      { path: 'exam/result', component: () => import('./views/CourseExamResult.vue'), props: true }
    ]
  }
]
