import { defineStore } from 'pinia'
import { getUser, logout } from '@/api/base'
import type { UserType } from '@/types'

interface State {
  user: UserType | null
}

export const useUserStore = defineStore({
  id: 'user',
  state: (): State => ({
    user: null
  }),
  getters: {
    isLogin: state => !!state.user,
    name: state => state.user?.realname || state.user?.nickname || state.user?.username
  },
  actions: {
    async getUser() {
      const res = await getUser()
      this.user = res.data
    },
    async logout() {
      await logout()
      this.user = null
    }
  }
})
