// json to array
export const json2Array = function (data: any, isValueToNumber = true) {
  return Object.keys(data).map(value => ({ label: data[value], value: isValueToNumber ? parseInt(value) : value }))
}

// 试题类型
export const questionType = {
  1: '单选题',
  2: '多选题',
  3: '问答题',
  5: '案例题',
  6: '判断题',
  7: '实操题',
  8: '情景题'
}
// 试题类型列表
export const questionTypeList = json2Array(questionType, false)

// 直播状态
export const liveStatus = {
  0: '未知',
  1: '直播未开始',
  2: '直播中',
  3: '直播已结束'
}
// 试题类型列表
export const liveStatusList = json2Array(liveStatus, false)

// 论坛检索范围
export const bbsSearchBy = {
  0: '全部帖子',
  1: '我发布的帖子',
  2: '我回复的帖子'
}
// 论坛检索范围列表
export const bbsSearchByList = json2Array(bbsSearchBy)

// 论坛检索范围
export const bbsOrderBy = {
  0: '默认排序',
  1: '热度从高-低',
  2: '时间由近-远',
  3: '时间由远-近'
}
// 论坛检索范围列表
export const bbsOrderByList = json2Array(bbsOrderBy)
