import { createRouter, createWebHistory } from 'vue-router'
import { useUserStore } from '@/stores/user'

const router = createRouter({
  history: createWebHistory(),
  routes: [{ path: '/:pathMatch(.*)*', redirect: '/' }]
})

router.beforeEach((to, from, next) => {
  const user = useUserStore()
  user.getUser()
  next()
})

export default router
