import { defineStore } from 'pinia'
import { getUser, logout } from '@/api/base'

import type { UserState } from '@/types'

export const useUserStore = defineStore({
  id: 'user',
  state: () => {
    return {
      user: null as UserState | null
    }
  },
  getters: {
    isLogin: state => !!state.user,
    userName: ({ user }) => {
      if (!user) return ''
      return user.realname || user.nickname || user.username || ''
    }
  },
  actions: {
    getUser() {
      return getUser().then(res => {
        this.user = res.data
      })
    },
    logout() {
      return logout().then(() => {
        this.user = null
      })
    }
  }
})
