import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取我的已做试题
 */
export function getMyQuestion(data) {
  return httpRequest.get('/zy/v2/examination/my-question', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/**
 * 获取我的试题详情
 */
export function getMyQuestionDetail(data) {
  return httpRequest.get('/zy/v2/examination/question/detail', data)
}

/**
 * 获取我的所有试题
 */
export function getAllQuestion(data) {
  return httpRequest.get('/zy/v2/examination/my-question-all', data)
}

/* 删除试题 */
export function deleteQuestion(data) {
  return httpRequest.post('/zy/v2/examination/delete-my-question', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 收藏试题 */
export function collectQuestion(data) {
  return httpRequest.post('/zy/v2/examination/add-collection', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 缓存试题 */
export function cacheQuestion(data) {
  return httpRequest.post('/zy/v2/examination/cache-question', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 意见反馈 */
export function submitFeedback(data) {
  return httpRequest.post('/zy/v2/feedback/commit', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

// /* 获取考试状态 */
// export function getExamStatus(data) {
//   return httpRequest.get('/zy/v2/examination/examination-papers-status', data, {
//     headers: { 'Content-Type': 'multipart/form-data' }
//   })
// }
