import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 随堂测试课程章节列表
 */
export function getCourseChapterList() {
  return httpRequest.get('/zy/v2/education/courses/my')
}

/* 模拟考试设置角色 */
export function setRole(data) {
  return httpRequest.post('/zy/v2/examination/role', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 获取考试状态 */
export function getExamStatus(data) {
  return httpRequest.get('/zy/v2/examination/examination-papers-status', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
