import BaseAPI from '@/api/base_api'
const httpRequest = new BaseAPI(webConf)

// 登录
export function login(data) {
  return httpRequest.post('/passport/rest/login', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
// 绑定微信
export function bindWechat(data) {
  return httpRequest.post('/passport/rest/wechat/bind-unionid', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
// 重置密码
export function resetPassword(data) {
  return httpRequest.post('/usercenter/user/update-pwd', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
// 发送重置验证码
export function sendResetPasswordCode(data) {
  return httpRequest.post('/usercenter/user/send-code', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
// 登出
export function logout() {
  return httpRequest.get('/passport/rest/logout')
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/zy/user/getinfo')
}
