import store from '@/store'
export default class Before {
  constructor(opt) {
    this.opt = opt || {}
  }

  async update(to, from, next) {
    if (to.meta.requiredLogin) {
      const isLogin = await store.dispatch('checkLogin')
      if (isLogin) {
        next()
      } else {
        store.state.isWeapp
          ? wx.miniProgram.redirectTo({ url: '/pages/login/index' })
          : next('/login')
      }
      return
    }
    next()
  }
}
