export default [
  { path: '/', redirect: '/index' },
  /* 测试页面 */
  { path: '/test', name: 'test', component: () => import('../pages/test.vue') },
  /* 课程检测 */
  {
    path: '/exam/abilityAnswer',
    name: 'abilityAnswer',
    component: () => import('../pages/courseExam/abilityAnswer.vue')
  },
  /* 能力自测首页 */
  {
    path: '/exam/index',
    name: 'examIndex',
    component: () => import('../pages/courseExam/index.vue')
  },
  /* 能力自测答题页面 */
  {
    path: '/exam/answer',
    name: 'examAnswer',
    component: () => import('../pages/courseExam/answer.vue')
  },
  /* 能力自测答题结果 */
  {
    path: '/exam/result',
    name: 'examResult',
    component: () => import('../pages/courseExam/answerResult.vue'),
    meta: { requiredLogin: true }
  },
  /* 能力自测答题结果 */
  {
    path: '/exam/courseNode',
    name: 'courseNode',
    component: () => import('../pages/courseExam/courseNode.vue'),
    meta: { requiredLogin: true }
  },
  /* 模拟考试 */
  {
    path: '/mock/index',
    name: 'mockIndex',
    component: () => import('../pages/mockExam/index.vue'),
    meta: { requiredLogin: true }
  },
  /* 模拟考试答题页面 */
  {
    path: '/mock/answer',
    name: 'mockAnswer',
    component: () => import('../pages/mockExam/answer.vue'),
    meta: { requiredLogin: true }
  },
  /* 模拟考试答题页面 */
  {
    path: '/mock/result',
    name: 'mockResult',
    component: () => import('../pages/mockExam/answerResult.vue'),
    meta: { requiredLogin: true }
  },
  /* 如果所有页面都没找到 - 指向 */
  { path: '*', component: () => import('@/components/errorPages/404.vue') },
  /* 首页 */
  {
    path: '/index',
    name: 'index',
    component: () => import('../pages/home/index.vue')
  },
  // 搜索
  {
    path: '/search',
    name: 'search',
    component: () => import('../pages/search/index.vue')
  },
  // 课程学习
  {
    path: '/course/learn',
    name: 'courseLearn',
    component: () => import('../pages/course/learn/index.vue')
  },
  // 课程学习详情
  {
    path: '/course/learn/:id',
    name: 'courseLearnItem',
    component: () => import('../pages/course/learn/item.vue'),
    meta: { requiredLogin: true }
  },
  // 课程学习详情
  {
    path: '/course/learn/:id/tag',
    name: 'courseLearnTag',
    component: () => import('../pages/course/tag/index.vue'),
    meta: { requiredLogin: true }
  },
  // 课程知识点
  {
    path: '/course/learn/:courseId/tag/:chapterId',
    name: 'courseTag',
    component: () => import('../pages/course/tag/list.vue'),
    meta: { requiredLogin: true }
  },
  // 课程知识点详情
  {
    path: '/course/tag',
    name: 'courseTag',
    component: () => import('../pages/course/tag/home.vue')
  },
  // 课程知识点详情
  {
    path: '/course/tag/:id',
    name: 'courseTagItem',
    component: () => import('../pages/course/tag/item.vue'),
    meta: { requiredLogin: true }
  },
  // 登录
  {
    path: '/login',
    name: 'login',
    component: () => import('../pages/login/login.vue')
  },
  // 我的
  {
    path: '/my',
    name: 'my',
    component: () => import('../pages/my/index.vue')
  },
  // 我的-已购课程
  {
    path: '/my/buyCourses',
    name: 'buyCourses',
    component: () => import('../pages/my/buyCourses.vue'),
    meta: { requiredLogin: true }
  },
  // 我的-已做试题
  {
    path: '/my/questionsList',
    name: 'questionsList',
    component: () => import('../pages/my/questionsList.vue'),
    meta: { requiredLogin: true }
  },
  // 错题列表
  {
    path: '/errorQuestionList',
    name: 'errorQuestionList',
    component: () => import('../pages/my/errorQuestionList.vue'),
    meta: { requiredLogin: true }
  },
  // 我的-已做试题详情
  {
    path: '/my/questionsDetails',
    name: 'questionsDetails',
    component: () => import('../pages/my/questionsDetails.vue'),
    meta: { requiredLogin: true }
  },
  // 我的-试题详情-答题卡
  {
    path: '/my/answerCard',
    name: 'answerCard',
    component: () => import('../pages/my/answerCard.vue'),
    meta: { requiredLogin: true }
  },
  // 我的-收藏试题
  {
    path: '/my/collectQuestions',
    name: 'collectQuestions',
    component: () => import('../pages/my/collectQuestions.vue'),
    meta: { requiredLogin: true }
  },
  // 我的-发票页面
  {
    path: '/my/invoice',
    name: 'myInvoice',
    component: () => import('../pages/my/invoice.vue'),
    meta: { requiredLogin: true }
  },
  // 我的-联系客服
  {
    path: '/my/service',
    name: 'myService',
    component: () => import('../pages/my/service.vue')
  },
  // 我的-意见反馈
  {
    path: '/my/feedback',
    name: 'myFeedback',
    component: () => import('../pages/my/feedback.vue')
  },
  // 支付
  {
    path: '/pay',
    name: 'pay',
    component: () => import('../pages/pay/index.vue'),
    meta: { requiredLogin: true }
  },
  // 下载资料
  {
    path: '/download',
    name: 'download',
    component: () => import('../pages/download/index.vue'),
    meta: { requiredLogin: true }
  },
  // 学习提醒
  {
    path: '/my/alarm',
    name: 'MyAlarm',
    component: () => import('../pages/my/alarm/index.vue'),
    meta: { requiredLogin: true }
  },
  // 已学课程
  {
    path: '/my/learn',
    name: 'MyLearn',
    component: () => import('../pages/my/learn/index.vue'),
    meta: { requiredLogin: true }
  }
]
