import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取商品详情
 */
export function getGoodsDetails(id) {
  return httpRequest.get(`/zy/v2/mall/product/${id}`)
}

/**
 * 获取我的购买订单
 */
export function getMyOrder() {
  return httpRequest.get('/zy/v2/mall/order/my')
}

/* 获取openid */
export function getOpenid(data) {
  return httpRequest.get('/usercenter/user/get-user-openid', data)
}

/* 监听支付状态 */
export function getOrderStatus() {
  return httpRequest.get('/v2/mall/order/status')
}
