import BaseACTION from '@/action/base_action'
import { Exam } from '../api'
export default class ExamAction extends BaseACTION {
  getPower(obj) {
    return Exam.getPower(obj).then(res => res)
  }

  getExam(obj, url) {
    return Exam.getExam(obj, url).then(res => {
      if (res.code !== 0) {
        return res.code
      }
      const _data = JSON.parse(res.data)
      const question = _data.sheet.questions.question_items.map(function(_) {
        return {
          type: _.question_type,
          score: _.score,
          id: _.question_item_id,
          question_list: _.question_list.map((e) => {
            return {
              question_analysis: e.question_analysis,
              question_answer: e.question_answer,
              question_content: e.question_content,
              id: e.id,
              question_options: e.question_options.map(res => {
                if (_.question_type === '2' || _.question_type === '5') {
                  if (_data.sheet.answers === null || Array.isArray(_data.sheet.answers)) {
                    return res
                  }
                  if (_data.sheet.answers[_.question_item_id] && _data.sheet.answers[_.question_item_id][e.id]) {
                    if (_data.sheet.answers[_.question_item_id][e.id].answer.find(item => { return item === res.id })) {
                      res.active = true
                    }
                  }
                }
                return res
              }),
              question_title: e.question_title,
              answerOpt: e.question_options.map((i, index) => {
                const answer = Array.isArray(e.question_answer) ? e.question_answer : [e.question_answer]
                const val = answer.find((item) => { return item === i.id })
                if (val) {
                  const opa = ['A', 'B', 'C', 'D', 'E', 'F', 'G']
                  return opa[index]
                }
              }).toString().replace(new RegExp(',', 'g'), ''),
              answer_count: e.answer_count
            }
          })
        }
      })
      const json = {
        user_id: _data.user_id,
        sheet: {
          id: _data.sheet.id,
          question_count: _data.sheet.questions.total_question_count,
          score: _data.sheet.questions.total_score,
          remainingTime: _data.sheet.remaining_times,
          duration: _data.sheet.duration
        },
        answers: _data.sheet.answers,
        questions: question,
        score_items: _data.sheet.score_items,
        created_time: _data.sheet.created_time,
        score: _data.sheet.score,
        total_score: _data.sheet.questions.total_score,
        status: _data.sheet.status
      }
      return json
    })
  }

  examSubmit(obj, url) {
    return Exam.examSubmit(obj, url).then(res => {
      return res
    })
  }
}
