import Cookies from 'js-cookie'
import VueI18n from 'vue-i18n'
import language from './language'
// import zhCNLocale from 'element-ui/lib/locale/lang/zh-CN'
// import enLocale from 'element-ui/lib/locale/lang/en'

export default () => {
  let _locale = 'zh-CN'
  /* 国际化初始化 */
  const _defaultLocale = 'zh-CN'
  const _lang = Cookies.get('lang') || window.navigator.language || window.navigator.userLanguage || ''
  if (_lang) {
    if (language[_lang]) {
      _locale = _lang
    } else {
      let flag = true
      /* 做一下 兼容性处理 */
      for (const k in language) {
        const reg = new RegExp(k, 'gi')
        if (reg.test(_lang)) {
          _locale = k
          flag = false
          break
        }
      }
      if (flag) {
        /* 当前语言版本 - 不再我们的语言库中，那么默认 en */
        _locale = _defaultLocale
        Cookies.set('lang', _defaultLocale, { expires: 30, domain: '.ezijing.com' })
      }
    }
  }
  return new VueI18n({
    locale: _locale, // 定义默认语言为中文
    messages: {
      'zh-CN': Object.assign(require('./zh-CN.json')),
      en: Object.assign(require('./en.json'))
    }
  })
}
