import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取课程提醒列表
 */
export function getAlarmList() {
  return httpRequest.get('/zy/v2/education/alarm/list')
}

/**
 * 获取课程提醒详情
 */
export function getAlarm(id) {
  return httpRequest.get(`/zy/v2/education/alarm/detail/${id}`)
}

/**
 * 添加课程提醒
 */
export function addAlarm(data) {
  return httpRequest.post('/zy/v2/education/alarm/add', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

/**
 * 更新课程提醒
 */
export function updateAlaram(data) {
  return httpRequest.post('/zy/v2/education/alarm/edit', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

/**
 * 删除课程提醒
 */
export function deleteAlaram(id) {
  return httpRequest.delete(`/zy/v2/education/alarm/delete/${id}`)
}

/**
 * 检查是否关注微信公众号
 */
export function checkFollowWechat(id) {
  return httpRequest.get('/zy/v2/education/hasguanzhu')
}
