import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取免费课程列表
 */
export function getFreeCourseList() {
  return httpRequest.get('/zy/v2/education/freecourse')
}

/**
 * 获取课程列表
 */
export function getCourseList() {
  return httpRequest.get('/zy/v2/education/courses/list')
}

/**
 * 获取课程详情
 * @param {string} courseId 课程ID
 */
export function getCourse(courseId) {
  return httpRequest.get(`/zy/v2/education/courses/${courseId}`)
}

/**
 * 获取课程知识点
 * @param {string} courseId 课程ID
 */
export function getCourseTagList(courseId) {
  return httpRequest.get(`/zy/v2/education/tag/tree/${courseId}`)
}

/**
 * 知识点详情
 * @param {string} tagId 知识点ID
 */
export function getCourseTag(tagId) {
  return httpRequest.get(`/zy/v2/education/tag/${tagId}`)
}

/**
 * 获取搜索记录
 */
export function getSearchTips() {
  return httpRequest.get('/zy/v2/education/search/tips')
}

/**
 * 知识点搜索
 */
export function getSearchTagList(data) {
  return httpRequest.post('/zy/v2/education/search/tag', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

/**
 * 视频课程搜索
 */
export function getSearchCourseVideoList(data) {
  return httpRequest.post('/zy/v2/education/search/chapter1', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

/**
 * 课程搜索
 */
export function getSearchCourseList(data) {
  return httpRequest.post('/zy/v2/education/search/chapter2', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
