import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)

/**
 * 获取商品详情
 */
export function getGoodsDetails(id) {
  return httpRequest.get(`/zy/v2/mall/product/${id}`)
}

/**
 * 获取我的购买订单
 */
export function getMyOrder() {
  return httpRequest.get('/zy/v2/mall/order/my')
}

/* 模拟考试设置角色 */
export function setRole(data) {
  return httpRequest.post('/zy/v2/examination/role', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 获取考试状态 */
export function getExamStatus(data) {
  return httpRequest.get('/zy/v2/examination/examination-papers-status', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 获取openid */
export function getOpenid(data) {
  return httpRequest.get('/usercenter/user/get-user-openid', data)
}
