import store from '@/store'
export default class Before {
  constructor(opt) {
    this.opt = opt || {}
  }

  async update(to, from, next) {
    if (to.meta.requiredLogin) {
      // 所有登录页 不进行登录校验
      const isLogin = await store.dispatch('checkLogin')
      if (isLogin) {
        next()
      } else {
        store.state.isWeapp ? this.wechatLogin() : next('/login')
      }
      return
    }
    next()
  }

  wechatLogin() {
    const appId = 'wxc6044475caf2805a'
    const wechatRedirectURL =
      webConf.isDev === 'production'
        ? 'https://passport.ezijing.com'
        : 'https://passport2.ezijing.com'
    // 回调地址
    const redirectURI = `${wechatRedirectURL}/rest/wechat/oauth-callback?needCheck=false&identity=transport&redirectUrl=${window.location.href}`
    // 微信的地址
    const wechatUrl = `https://open.weixin.qq.com/connect/oauth2/authorize?appid=${appId}&redirect_uri=${encodeURIComponent(
      redirectURI
    )}&response_type=code&scope=snsapi_userinfo&state=STATE#wechat_redirect`
    // 打开地址
    window.location.href = wechatUrl
  }
}
