import BaseAPI from '@/api/base_api'

const httpRequest = new BaseAPI(webConf)
/**
 * 获取搜索记录
 */
export function getSearchTips() {
  return httpRequest.get('/zy/v2/education/search/tips')
}

/**
 * 知识点搜索
 */
export function getSearchTagList(data) {
  return httpRequest.post('/zy/v2/education/search/tag', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

/**
 * 视频课程搜索
 */
export function getSearchCourseVideoList(data) {
  return httpRequest.post('/zy/v2/education/search/chapter1', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}

/**
 * 课程搜索
 */
export function getSearchCourseList(data) {
  return httpRequest.post('/zy/v2/education/search/chapter2', data, {
    headers: { 'Content-Type': 'application/x-www-form-urlencoded' }
  })
}
