import Vue from 'vue'
import router from './router'
import store from './store'
import App from './app.vue'
import './style.scss'
import ElementUI from 'element-ui'

import BeforeEnter from './utils/beforeEnter'
const before = new BeforeEnter()

Vue.use(ElementUI)

/* 导航守卫 */
router.beforeEach((to, from, next) => {
  before.update(to, from, next)
})

Vue.prototype.msgCenter = new Vue()

new Vue({
  store,
  router,
  render: h => h(App)
}).$mount('#app')
