import httpRequest from '@/utils/axios'

// 用户群列表
export function groupList(params = {}) {
  return httpRequest.get('/api/opera/v1/oprations/cgroups', { params })
}

// 添加用户群
export function groupAdd(data) {
  return httpRequest.post('/api/opera/v1/oprations/cgroup', data)
}

// 获取用户群详情
export function groupInfo(id, params = {}) {
  return httpRequest.get(`/api/opera/v1/oprations/${id}/cgroup`, { params })
}

// 更新用户群信息
export function groupUpdate(id, data = {}) {
  return httpRequest.put(`/api/opera/v1/oprations/${id}/cgroup`, data)
}

// 删除用户群
export function groupDelete(id, params = {}) {
  return httpRequest.delete(`/api/opera/v1/oprations/${id}/cgroup`, { params })
}
