import httpRequest from '@/utils/axios'

// 特征模板列表
export function characteristicsTemplateList(params = {}) {
  return httpRequest.get('/api/opera/v1/oprations/characteristics-templates', { params })
}

// 创建用户群特征模板
export function characteristicsTemplateCreate(data) {
  var headers = {
    'Content-Type': 'application/json'
  }
  return httpRequest.post('/api/opera/v1/oprations/characteristics-template', data, { headers })
}

// 特征模板详情
export function characteristicsTemplateInfo(id, params) {
  return httpRequest.get(`/api/opera/v1/oprations/${id}/characteristics-template`, { params })
}

// 更新特征模板
export function characteristicsTemplateUpdate(id, data) {
  return httpRequest.get(`/api/opera/v1/oprations/${id}/characteristics-template`, data)
}

// 删除特征模板
export function characteristicsTemplateDelete(id) {
  return httpRequest.delete(`/api/opera/v1/oprations/${id}/characteristics-template`)
}
