import httpRequest from '@/utils/axios'

// 添加触达
export function reachCreate(data) {
  return httpRequest.post('/api/opera/v1/oprations/reach', data)
}

// 触达列表
export function reachList(params = {}) {
  return httpRequest.get('/api/opera/v1/oprations/reachs', { params })
}

// 触达详情
export function reachInfo(id, params = {}) {
  return httpRequest.get(`/api/opera/v1/oprations/${id}}/reach`, { params })
}

// 触达更新
export function reachUpdate(id, data = {}) {
  return httpRequest.put(`/api/opera/v1/oprations/${id}}/reach`, data)
}

// 触达删除
export function reachDelete(id, params = {}) {
  return httpRequest.delete(`/api/opera/v1/oprations/${id}}/reach`, { params })
}
