import httpRequest from '@/utils/axios'

// 登录
export function login(data) {
  return httpRequest.post('/api/passport/rest/login', data)
}
// 绑定微信
export function bindWechat(data) {
  return httpRequest.post('/api/passport/rest/wechat/bind-unionid', data)
}
// 修改密码
export function updatePassword(data) {
  return httpRequest.post('/api/usercenter/user/change-pwd-by-cookie', data)
}
// 重置密码
export function resetPassword(data) {
  return httpRequest.post('/api/usercenter/user/update-pwd', data)
}
// 发送重置验证码
export function sendResetPasswordCode(data) {
  return httpRequest.post('/api/usercenter/user/send-code', data)
}
// 登出
export function logout() {
  return httpRequest.get('/api/passport/rest/logout')
}
// 获取用户信息
export function getUser() {
  return httpRequest.get('/api/zy/user/getinfo')
}
// 绑定游客
export function bindVisitor(data) {
  return httpRequest.post('/api/zy/user/bind-account', data)
}
// 获取是否VIP
export function getIsVip() {
  return httpRequest.get('/api/zy/user/is-vip')
}
// 创建游客用户
export function createGuestUser() {
  return httpRequest.get('/api/zy/user/create-guest-user')
}
