import httpRequest from '@/utils/axios'

/**
 * 随堂测试课程章节列表
 */
export function getCourseChapterList() {
  return httpRequest.get('/api/zy/v2/education/courses/my')
}

/* 模拟考试设置角色 */
export function setRole(data) {
  return httpRequest.post('/api/zy/v2/examination/role', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 获取考试状态 */
export function getExamStatus(data) {
  return httpRequest.get('/api/zy/v2/examination/examination-papers-status', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/* 知识点考题获取 */
export function getExam(data) {
  return httpRequest.get('/api/zy/v2/examination/course-papers', data)
}

/* 知识点考题缓存 */
export function cacheExam(data) {
  return httpRequest.post('/api/zy/v2/examination/course-papers', data, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}
