import httpRequest from '@/utils/axios'
/**
 * 获取考前摸底试题
 */
export function getExamQuestion(params) {
  return httpRequest.get('/api/zy/v2/examination/examination-papers', { params }, { headers: { 'Content-Type': 'multipart/form-data' } })
}

/**
 * 缓存考前摸底试题
 */
export function setCache(params) {
  return httpRequest.post('/api/zy/v2/examination/examination-papers', params)
}

/**
 * 获取考试的状态
 */
export function getExamStatus(params) {
  return httpRequest.get('/api/zy/v2/examination/examination-papers-status', { params })
}

/**
 * 模拟考试设置角色
 */
export function setRoles(params) {
  return httpRequest.post('/api/zy/v2/examination/role', params)
}

/**
 * 获取我的已做试题
 */
export function getMyQuestion(params) {
  return httpRequest.get('/api/zy/v2/examination/my-question', { params }, {
    headers: { 'Content-Type': 'multipart/form-data' }
  })
}

/**
 * 获取我的所有试题
 */
export function getAllQuestion(params) {
  return httpRequest.get('/api/zy/v2/examination/my-question-all', { params })
}

/**
* 缓存错题集
*/
export function setMyCache(params) {
  return httpRequest.post('/api/zy/v2/examination/cache-question', params)
}

/**
 * 收藏试题
 */
export function addCollection(params) {
  return httpRequest.post('/api/zy/v2/examination/add-collection', params)
}

/**
 * 取消收藏试题
 */
export function deleteCollection(params) {
  return httpRequest.post('/api/zy/v2/examination/delete-my-question', params)
}

/**
 * 删除试题
 */
export function deleteQuestion(params) {
  return httpRequest.post('/api/zy/v2/examination/delete-my-question', params)
}

/**
 * 知识点题获取
 */
export function getCourseQuestion(params) {
  return httpRequest.get('/api/zy/v2/examination/course-papers', { params })
}

/**
 * 知识点题缓存
 */
export function setCourseCache(params) {
  return httpRequest.post('/api/zy/v2/examination/course-papers', params)
}
