import httpRequest from '@/utils/axios'

/**
 * 获取我的试题
 */
export function getMyQuestions(params) {
  return httpRequest.get('/api/zy/v2/examination/my-question', { params })
}

/**
 * 删除试题
 */
export function deleteQuestion(data) {
  return httpRequest.post('/api/zy/v2/examination/delete-my-question', data)
}

/**
 * 收藏试题
 */
export function addCollection(data) {
  return httpRequest.post('/api/zy/v2/examination/add-collection', data)
}

/**
 * 取消收藏试题
 */
export function deleteCollection(data) {
  return httpRequest.post('/api/zy/v2/examination/delete-my-question', data)
}
