import axios from 'axios'
import qs from 'qs'
import { Message } from 'element-ui'

const httpRequest = axios.create({
  // baseURL: process.env.VUE_APP_BASE_API,
  timeout: 60000,
  withCredentials: true,
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded',
    tenant: 'transport'
  }
})

// 请求拦截
httpRequest.interceptors.request.use(
  function(config) {
    if (config.headers['Content-Type'] === 'application/x-www-form-urlencoded') {
      config.data = qs.stringify(config.data)
    }
    return config
  },
  function(error) {
    return Promise.reject(error)
  }
)

// 响应拦截
httpRequest.interceptors.response.use(
  function(response) {
    const { data } = response
    if (data.code) {
      Message.error(data.msg)
      return Promise.reject(data)
    }
    return data
  },
  function(error) {
    console.log(error.response)
    if (error.response) {
      const { status, message } = error.response.data
      // 未登录
      if (status === 403) {
        window.location.href = `${webConf.others.loginUrl}?rd=${encodeURIComponent(window.location.href)}`
      }
      Message.error(message || error.response.data)
      return Promise.reject(error.response)
    } else {
      Message.error(error)
    }
    return Promise.reject(error)
  }
)

export default httpRequest
