import store from '@/store'

export default class BeforeEnter {
  constructor(opt) {
    this.opt = opt || {}
  }

  async update(to, from, next) {
    // 设置游客用户信息
    const { user_id: userId, student_id: studentId } = to.query
    if (userId && studentId) {
      store.commit('setGuestUser', { user_id: userId, student_id: studentId })
    }
    // 创建游客用户
    // await store.dispatch('createGuestUser')

    const isLogin = store.state.isLogin || (await store.dispatch('checkLogin'))

    if (to.meta.requiredLogin && !isLogin) {
      next(`/login?redirect_uri=${encodeURIComponent(window.location.href)}`)
      return
    }
    next()
  }
}
