import httpRequest from '@/utils/axios'

// 案例列表
export function caseList(params) {
  return httpRequest.get('/api/opera/v1/operations/cases', { params })
}

// 案例详情
export function caseInfo(id, params = {}) {
  return httpRequest.get(`/api/opera/v1/operations/${id}/case`, { params })
}

// 添加案例背景
export function caseCreate(data) {
  return httpRequest.post('/api/opera/v1/operations/case', data)
}

// 更新案例背景
export function caseUpdate(id, data) {
  return httpRequest.put(`/api/opera/v1/operations/${id}/case`, data)
}

// 删除案例背景
export function caseDelete(id, params = {}) {
  return httpRequest.delete(`/api/opera/v1/operations/${id}/case`, { params })
}
