import httpRequest from '@/utils/axios'

// 绑定微信
export function bindWechat(data) {
  return httpRequest.post('/api/passport/rest/wechat/bind-unionid', data)
}
// 获取触达方式列表
export function getTriggerWayList() {
  return httpRequest.get('/api/opera/v1/oprations/reach/ways')
}

// 获取触达方式详情
export function triggerWay(id) {
  return httpRequest.get(`/api/opera/v1/oprations/reach/${id}/way`)
}

// 编辑触达方式
export function triggerWayUpdate(id, data) {
  return httpRequest.put(`/api/opera/v1/oprations/reach/${id}/way`, data)
}

// 创建触达方式
export function triggerWayCreate(data) {
  return httpRequest.post('/api/opera/v1/oprations/reach/way', data)
}

// 删除触达方式
export function triggerWayDelete(id, params = {}) {
  return httpRequest.delete(`/api/opera/v1/oprations/reach/${id}/way`, { params })
}

// 获取触达时间列表
export function getTriggerDateList() {
  return httpRequest.get('/api/opera/v1/oprations/reach/dates')
}

// 获取触达时间详情
export function triggerDate(id) {
  return httpRequest.get(`/api/opera/v1/oprations/reach/${id}/date`)
}

// 编辑触达时间
export function triggerDateUpdate(id, data) {
  return httpRequest.put(`/api/opera/v1/oprations/reach/${id}/date`, data)
}

// 创建触达时间
export function triggerDateCreate(data) {
  return httpRequest.post('/api/opera/v1/oprations/reach/date', data)
}

// 删除触达时间
export function triggerDateDelete(id, params = {}) {
  return httpRequest.delete(`/api/opera/v1/oprations/reach/${id}/date`, { params })
}
