import httpRequest from '@/utils/axios'

/**
 * 获取产品类型列表
 */
export function getReport() {
  return httpRequest.get('/api/xtraining/api/v1/marketing/report-detail').then({})
}

// 提交报告
export function submitReport(data) {
  return httpRequest.post('/api/xtraining/api/v1/marketing/submit-report', data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

// 保存营销工具记录
export function cacheReport(id, data) {
  return httpRequest.post(`/api/xtraining/api/v1/answer/${id}/save-marketing-record`, data, {
    headers: { 'Content-Type': 'application/json' }
  })
}

// 获取营销工具报告详情
export function getReportDetail(id) {
  return httpRequest.get(`/api/xtraining/api/v1/answer/${id}/marketing-report`).then({})
}

// 验证是否有未完成的答题记录
export function checkRecord(id, type) {
  return httpRequest.post(`/api/xtraining/api/v1/answer/${id}/check-record/${type}`, {}, {
    headers: { 'Content-Type': 'application/json' }
  })
}
