import httpRequest from '@/utils/axios'

/** 获取用户分析多选题 */
export function getQuestions() {
  return httpRequest.get('/api/xtraining/api/v1/analysis-users/multiple-questions')
}
/** 获取用户列表 */
export function getUserList(params) {
  return httpRequest.get('/api/xtraining/api/v1/analysis-users', { params })
}
/** 获取当前选择题对应的图表数据 */
export function getChart(params) {
  return httpRequest.get('/api/xtraining/api/v1/analysis-users/chart', { params })
}
/** 提交用户分析报告 */
export function submitReport(data) {
  return httpRequest.post('/api/xtraining/api/v1/analysis-users/report', data)
}
