import httpRequest from '@/utils/axios'

/**
 * 获取产品类型列表
 */
export function getCategories(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/categories`).then({})
}

// 获取案例列表
export function getCasesList(id) {
  return httpRequest.get(`/api/xtraining/api/v1/${id}/cases`)
}

// 选中案例
export function selectCase(id) {
  return httpRequest.post(`/api/xtraining/api/v1/${id}/select-case`, {})
}

// 发票充值
export function deposit() {
  return httpRequest.post('/api/finance/v1/invoices/deposit')
}

// 下载发票列表
export function downloadInvoices(params) {
  return httpRequest.get('/api/finance/v1/invoices/download', { params, responseType: 'blob' })
}
